#include <allegro.h>
#ifndef NO_GL
#include <alleggl.h>
#endif
#include <stdio.h>
#include <string.h>

#include "main.h"
#include "draw.h"
#include "game.h"
#include "start.h"
#include "title.h"
#include "letters.h"
#include "midi.h"
#include "credits.h"

char credits[] = "\
             PEACE INVADERS             |\
                                        |\
             SPEEDHACK ZOOZ             |\
                                        |\
                CREDITS                 |\
                                        |\
                  CODE                  |\
                                        |\
        ELIAS NETWORM PSCHERNIG         |\
                                        |\
                 MUSIC                  |\
                                        |\
         TONI XVIILA YLISIRNIO          |\
                                        |\
            BEN ENTHEH DAVIS            |\
                                        |\
               SPEEDHACK                |\
                                        |\
          ARRON SNOWBEAR SHUTT          |\
                                        |\
       MATTHEW KONFORCE LEVERTON        |\
                                        |\
                ALLEGRO                 |\
                                        |\
        SHAWN THE ONE HARGREAVES        |\
                                        |\
   RANDOM SELECTION FROM CONTRBUTORS    |\
                                        |\
          ANGELO LILLO MOTTOLA          |\
                                        |\
             ERIC BOTCAZOU              |\
                                        |\
        GRZEGORZ ADAM HANKIEWICZ        |\
                                        |\
            HENRIK STOKSETH             |\
                                        |\
            LAURENCE WITHERS            |\
                                        |\
           PETER TJADEN WANG            |\
                                        |\
        ROBIN ODDISH BURROWS            |\
                                        |\
               ALLEGROGL                |\
                                        |\
        RBOBERT J BOB OHANNESION        |\
                                        |\
           GEORGE GFOOT FOOT            |\
";


static int creditspos;
static char lastline[256];
static int scroll;

static void getline(void)
{
	int l;
	if (credits[creditspos] == '\0') creditspos = 0;
	for(l = 0; l < 40; l++) lastline[l] = ' ';
	l = 0;
	for(; credits[creditspos] != '|'; creditspos++) {
		if (credits[creditspos] == '\0') break;
		lastline[l] = credits[creditspos];
		l++;
	}
	creditspos++;
	lastline[40] = '\0';
}

void credits_init(void)
{
	scroll = 0;
}

void credits_input(void)
{
	scroll++;
}

void credits_render(void)
{
	int y = 0;
#ifndef NO_GL
	glClearColor(0.0, 0.0, 0.0, 1.0);
	glClear(GL_COLOR_BUFFER_BIT);
#else
	clear_to_color(page, 0);
#endif
	creditspos = 0;

	for(;;) {
		getline();
		{
#ifndef NO_GL
			letters_draw(80, SCREEN_H - scroll / 3 + y, 4 * 7 + 32 * 7, lastline, lastline, 0);
#else
			letters_draw(80, SCREEN_H - scroll / 3 + y, 4 * 7 + 32 * 7, lastline, lastline, 0);
#endif
			y += 30;
		}
		if (credits[creditspos] == '\0') break;
	}
}
